package game;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

import javax.swing.JOptionPane;

public class PackerUnpacker {
	
	private String mainFileName = null;
	private HashMap<String, String> unpackedFilenames = new HashMap<String, String>();
	
	public boolean pack(String origFile, String outFile) {
		
		
//		JOptionPane.showMessageDialog(null, "Check it now","asdf",JOptionPane.INFORMATION_MESSAGE);
		
		
		BusyPanel.showWaitBox(BusyPanel.PREPARE, null);
		
		BufferedReader bufferedIn = null;
		
		try {
			bufferedIn = new BufferedReader(new FileReader(origFile));
		} catch(FileNotFoundException fnfe) {
			JOptionPane.showMessageDialog(null, "Error:  file " + origFile + " not found" ,"File not found", JOptionPane.ERROR_MESSAGE);
			return false;
		}
		
		HashMap<String, Long> fileLengths = new HashMap<String, Long>();
		
		try {
			
			String inputter = bufferedIn.readLine();
			
//			if(inputter == null || !inputter.equalsIgnoreCase("file")) {
//				JOptionPane.showMessageDialog(null, "unable to read from file " + origFile ,"File was not a packfile!", JOptionPane.ERROR_MESSAGE);
//			}
			
			
			while(RoomData.retrieveFileLengths(bufferedIn, origFile, null, null, true, fileLengths));
			
			
			
//			System.out.println("<><>DELME the size of fileLengths is: " + fileLengths.size());
			
//			Set<String> files = fileLengths.keySet();
//			
//			for(String s : files) {
//				System.out.println("<><>DELME a file named " + s + " has length: " + fileLengths.get(s));
//			}
			
			
			bufferedIn.close();
			
//			JOptionPane.showMessageDialog(null, "Check now!");
			
			
			StringBuffer mainFileContents = new StringBuffer();
			
			FileInputStream fis = new FileInputStream(origFile);
			
			long sizeOfMainFile = 0L;
			
			int inputChar;
			
			while((inputChar = fis.read()) != -1) {
				sizeOfMainFile++;
				mainFileContents.append((char) inputChar);
			}
			
			fis.close();
			
			fileLengths.put(origFile, sizeOfMainFile);
			
//			JOptionPane.showMessageDialog(null, "FYI:  sizeOfMainFile is: " + sizeOfMainFile + ", and mainFileContents.size: " + mainFileContents.length(),"FYI",JOptionPane.INFORMATION_MESSAGE);
			
			String mainFileContentsStr = mainFileContents.toString();
			
			
			HashMap<String, String> smallToBigNames = new HashMap<String, String>();
			HashMap<String, String> bigToSmallNames = new HashMap<String, String>();
			
			determineBestFileNames(smallToBigNames, bigToSmallNames, fileLengths, origFile);
			
			
			Set<String> bigFileNames = bigToSmallNames.keySet();
			
			for(String bigName : bigFileNames) {
				mainFileContentsStr = mainFileContentsStr.replace(bigName, bigToSmallNames.get(bigName));
			}
			
			
			fileLengths.remove(origFile);
			
			BusyPanel.hideWaitBox();
			
			BusyPanel.showWaitBox(BusyPanel.PACK, null);
			
			FileOutputStream out = new FileOutputStream(outFile);
			
			out.write("pack\n".getBytes());
			
			//now, we write the binary files one by one!
			
			writeText(origFile, sizeOfMainFile, out, bigToSmallNames, mainFileContentsStr);
			
			smallToBigNames.remove(bigToSmallNames.remove(origFile));  //lol
			
			
			Set<String> bigNames = bigToSmallNames.keySet();
			
			for(String bigName : bigNames) {
				
//				if(!fileLengths.containsKey(bigName)) {
//					System.err.println("the map doesn't contain the name " + bigName);
//				}
				
				writeBinaryFileContents(
						bigName, 
						fileLengths.get(bigName), 
						out, 
						bigToSmallNames);
				
			}
			
			
			//and we are theoretically done!
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
			BusyPanel.hideWaitBox();
			JOptionPane.showMessageDialog(null, "Error while loading from file " + origFile ,"I/O Error", JOptionPane.ERROR_MESSAGE);
			return false;
		}
		
		
		BusyPanel.hideWaitBox();
		
		return true;
	}
	
	

	public void determineBestFileNames(
			HashMap<String, String> smallToBigNames, 
			HashMap<String, String> bigToSmallNames,
			HashMap<String, Long> binaryFileLengths,
			String nameOfMainFile) {

		int indexOfSlash = -1;
		
		String tempName = null;
		
		Set<String> keys = binaryFileLengths.keySet();
		
		for(String key : keys) {
			
			
			
//			System.out.println("]]image file]]" + key + "[[");
			
			indexOfSlash = Math.max(key.lastIndexOf('/'), key.lastIndexOf('\\'));
			tempName = (nameOfMainFile.equals(key) ? "**" : "*") + key.substring(indexOfSlash + 1);
						
			for(int i = 0; !key.equals(smallToBigNames.get(tempName)) && smallToBigNames.containsKey(tempName); i++) {
				tempName = (nameOfMainFile.equals(key) ? "**c" : "*c") + i + "_" + key.substring(indexOfSlash + 1);
			}
			
			smallToBigNames.put(tempName, key);
			bigToSmallNames.put(key, tempName);
			
		}
		
		
//		keys = bigToSmallNames.keySet();
//		for(String key : keys) {
//			System.out.println("=======big name:  >" + key + "< ...and a small one: >" + bigToSmallNames.get(key) + "<");
//		}
		
		
	}
	
	

	public void writeBinaryFileContents(String fileName, long length, OutputStream out, HashMap<String, String> bigToSmallNames) throws IOException {
		
		out.write(bigToSmallNames.get(fileName).getBytes());
		out.write("\n".getBytes());
		
		out.write(Long.toString(length).getBytes());
		out.write("\n".getBytes());
		
		FileInputStream in = new FileInputStream(fileName);
		
		int inputter;
		long countOfChars = 0L;
		
		while((inputter = in.read()) != -1) {
			out.write(inputter);
			countOfChars++;
		}
		
		out.write("\n".getBytes());
		
//		if(countOfChars != length) {
//			System.out.println("the binary file " + fileName + " was expected to have " + length + " characters, but in fact had " + countOfChars);
//		} else {
//			System.out.println("the binary file " + fileName + " was expected to have " + length + " characters, and did.");
//		}
		
		in.close();
		
	}
	
	
	public void writeText(String fileName, long length, OutputStream out, HashMap<String, String> bigToSmallNames, String text) throws IOException {
		
		out.write(bigToSmallNames.get(fileName).getBytes());
		out.write("\n".getBytes());
		
//		System.out.println(";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  length of the bytes string: " + text.getBytes().length);
		
		out.write(Integer.toString(text.getBytes().length).getBytes());
		out.write("\n".getBytes());
		
		out.write(text.getBytes());
		
		out.write("\n".getBytes());
		
		
		
	}
	
	
	public boolean unpack(String folder, String packedFileName) {
		
		
		boolean returnValue = false;
		
		try {
			
			BusyPanel.showWaitBox(BusyPanel.UNPACK, null);
			
			FileInputStream in = new FileInputStream(packedFileName);
			
			String inputter = readLineFromStream(in);
			
			if(!inputter.trim().equalsIgnoreCase("pack")) {
				JOptionPane.showMessageDialog(null, "The selected file doesn't appear to be a packfile.","Error",JOptionPane.ERROR_MESSAGE);
				return false;
			}
			
			while(unpackBinaryFile(in, folder)) {
//				System.out.println("...seems we've written something out...");
			}
			
			cleanseMainFile();
			
			BusyPanel.hideWaitBox();
			
//			JOptionPane.showMessageDialog(null, "Files were unpacked successfully!", "Unpack Successful!", JOptionPane.INFORMATION_MESSAGE);
			
			returnValue = true;
			
		} catch (FileNotFoundException e) {
			JOptionPane.showMessageDialog(null, "Error; a file was not found while unpacking: " + e.getMessage());
		} catch (IOException e) {
			JOptionPane.showMessageDialog(null, "Error; there was an input/output error while unpacking: " + e.getMessage());
		} finally {
			BusyPanel.hideWaitBox();
		}
		
		
		return returnValue;
		
	}


	public boolean unpackBinaryFile(InputStream in, String folder) throws IOException {
		
		String inputter = readLineFromStream(in);
		if(inputter == null || inputter.length() == 0) {
//			System.out.println("we tried to get the name of the binary file; what did we input, just now?  <<" + inputter + ">>");
			if(inputter.length() == 0) {
				inputter = readLineFromStream(in);
				if(inputter == null || inputter.length() == 0) {
//					System.out.println("...second time didn't work either; got this: <<" + inputter + ">>");
					return false;
				}
			}
			
		}
		String fileName;
		
		if(inputter.contains("**")) {
			fileName = inputter.replace("**", folder + "/");
			mainFileName = fileName;
		} else {
			fileName = inputter.replace("*", folder + "/");
			
			this.unpackedFilenames.put(inputter.trim(), fileName.trim());
		}
		
//		System.out.print("just read in a binary file name: " + inputter + ", which will be called <<" + fileName + ">>");
		
		FileOutputStream out = new FileOutputStream(fileName);
		
		inputter = readLineFromStream(in);
		if(inputter == null || inputter.length() == 0) {
//			System.out.println("we tried to get the count of characers in the binary file; what did we input, just now?  <<" + inputter + ">>");
			return false;
		}
		long countOfChars = Long.parseLong(inputter);
		
//		System.out.println("...and the count of characters: " + countOfChars);
		
		boolean returnValue = true;
		int reader = -1;
		
		for(long i = 0; i < countOfChars; i++) {
			reader = in.read();
			if(reader == -1) {
				returnValue = false;
//				System.out.println("the in.read method got a -1, oddly...");
				break;
			}
			out.write(reader);
		}
		
		out.flush();
		out.close();
		
//		System.out.println("about to return this from unpackBinaryFile");
		return returnValue;
		
	}
	
	private String readLineFromStream(InputStream in) throws IOException {
		
		ArrayList<Byte> byteArray = new ArrayList<Byte>();
		int inputter = in.read();
		while(inputter != -1 && inputter != '\n' && inputter != '\r') {
			byteArray.add(new Byte((byte) inputter));
			inputter = in.read();
		}
		
		return convertByteArrayListToString(byteArray);
		
	}
	

	private String convertByteArrayListToString(ArrayList<Byte> arrayList) {
		
		StringBuffer returnValue = new StringBuffer();
		
		for(Byte b : arrayList) {
			returnValue.append((char) b.byteValue());
		}
		
		
//		System.out.println("let's see if this is proper; the returnValue is:  <<" + returnValue + ">>");
		return returnValue.toString();
	}
	
	
	public String getMainFileName() {
		return mainFileName;
	}
	
	
	private void cleanseMainFile() throws IOException {
		
		BufferedReader reader = new BufferedReader(new FileReader(mainFileName));
		
		ArrayList<String> newLines = new ArrayList<String>();
		
		String inputter = null;
		
		
		Set<String> allSmallNames = unpackedFilenames.keySet();
		
		while((inputter = reader.readLine()) != null) {
			
			for(String s : allSmallNames) {
				if(inputter.contains(s)) {
					inputter = inputter.replace(s, unpackedFilenames.get(s));
					break;
				}
			}
			
			newLines.add(inputter);
			
		}
		
		reader.close();
		
		
		BufferedWriter writer = new BufferedWriter(new FileWriter(mainFileName));
		
		for(String s : newLines) {
			writer.write(s);
			writer.newLine();
		}
		
		writer.flush();
		writer.close();
		
	}
	
	public static int numberOfRooms = 0;
	
}
